// https://forex-station.com/viewtopic.php?p=1295413891#p1295413891
// modified by banzai; July/1/20
// thanks to jeanlouie codes and templates @ https://www.forexfactory.com/jeanlouie
//------------------------------------------------------------------
#property copyright "www.forex-station.com"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_chart_window
#property indicator_buffers 4
//#property indicator_color1  clrLimeGreen
//#property indicator_color2  clrOrange
//#property indicator_color3  clrLimeGreen
//#property indicator_color4  clrOrange
//#property indicator_width3  3
//#property indicator_width4  3
#property strict

enum enTimeFrames
{
   tf_cu  = 0,              // Current time frame
   tf_m1  = PERIOD_M1,      // 1 minute
   tf_m5  = PERIOD_M5,      // 5 minutes
   tf_m15 = PERIOD_M15,     // 15 minutes
   tf_m30 = PERIOD_M30,     // 30 minutes
   tf_h1  = PERIOD_H1,      // 1 hour
   tf_h4  = PERIOD_H4,      // 4 hours
   tf_d1  = PERIOD_D1,      // Daily
   tf_w1  = PERIOD_W1,      // Weekly
   tf_mb1 = PERIOD_MN1,     // Monthly
   tf_cus = 1234567890      // Custom time frame
};

extern enTimeFrames        TimeFrame             = tf_cu;            // Time frame
extern int                 TimeFrameCustom       = 0;                // Custom time frame to use (if custom time frame used)
extern double              AccStep               = 0.02;             // Accumulation step
extern double              AccLimit              = 0.2;              // Accumulation limit
extern ENUM_APPLIED_PRICE  PriceHigh             = PRICE_CLOSE;      // Psar high price
extern ENUM_APPLIED_PRICE  PriceLow              = PRICE_CLOSE;      // Psar low price
extern int                 PriceSmoothing        = 0;                // Psar smoothing
extern ENUM_MA_METHOD      PriceSmoothingMethod  = MODE_SMA;         // Psar ma smoothing method
extern bool                alertsOn              = true;             // Alerts on?
extern bool                alertsOnCurrent       = false;            // Alerts on current open bar?
extern bool                alertsMessage         = true;             // Alerts message?
extern bool                alertsSound           = false;            // Alerts sound?
extern bool                alertsEmail           = false;            // Alerts email?
extern bool                alertsNotify          = false;            // Alerts notification by phone?
extern bool                DrawAsDots            = true;             // Draw as dots or solid line
extern int                 Shift                 = 0;                // Shift
extern bool                Interpolate           = true;             // Interpolate in multi time frame?     

//template code start1
extern string              note1                 = "------------------------------";
extern int                 UpperSARwidth         = 2;
extern int                 LowerSARwidth         = 2;
extern int                 UpperSARstartWidth    = 2;
extern int                 LowerSARstartWidth    = 2;
extern color               UpperSARcolor         = clrLimeGreen;
extern color               LowerSARcolor         = clrOrange;
extern color               UpperSARstartColor    = clrDarkGreen;
extern color               LowerSARstartColor    = clrCrimson;
extern int                 UpperSARfontCode      = 159;
extern int                 LowerSARfontCode      = 159;
extern int                 UpperSARstartFontCode = 221;
extern int                 LowerSARstartFontCode = 222;

// for mtf, insert the following line to #define _mtfCall(_buff,_y)
//note2,btn_show,btn_corner,btn_pressed,btn_unpressed,btn_offset_x,btn_offset_y,btn_width,btn_height,btn_font_size,btn_font_clr,btn_bg_color,btn_border_clr,note3,
extern string              note2                 = "------------------------------";
extern bool                btn_show              = true;                                //btn__show
extern ENUM_BASE_CORNER    btn_corner            = CORNER_LEFT_UPPER; // chart corner for anchoring
extern string              btn_pressed           = "PSAR";                      //btn__pressed text
extern string              btn_unpressed         = "PSAR";                    //btn__unpressed text
extern int                 btn_offset_x          = 20;                                     //btn__x
extern int                 btn_offset_y          = 20;                                     //btn__y
extern int                 btn_width             = 60;                                 //btn__width
extern int                 btn_height            = 20;                                //btn__height
extern int                 btn_font_size         = 10;                             //btn__font size
extern color               btn_font_clr          = clrBlack;                      //btn__font color
extern color               btn_bg_color          = clrGray;                         //btn__bg color
extern color               btn_border_clr        = clrWhiteSmoke;               //btn__border color
extern string              aButtonName           = "PSAR_CurrentTimeFrame";
extern string              note3                 = "------------------------------";

//template code end1

double sarUp[],sarDn[],saraUp[],saraDn[],count[];
string indicatorFileName;
#define _mtfCall(_buff,_y) iCustom(NULL,TimeFrame,indicatorFileName,tf_cu,0,AccStep,AccLimit,PriceHigh,PriceLow,PriceSmoothing,PriceSmoothingMethod,alertsOn,alertsOnCurrent,alertsMessage,alertsSound,alertsEmail,alertsNotify,DrawAsDots,Shift,Interpolate,note1,UpperSARwidth,LowerSARwidth,UpperSARstartWidth,LowerSARstartWidth,UpperSARcolor,LowerSARcolor,UpperSARstartColor,LowerSARstartColor,UpperSARfontCode,LowerSARfontCode,UpperSARstartFontCode,LowerSARstartFontCode,note2,btn_show,btn_corner,btn_pressed,btn_unpressed,btn_offset_x,btn_offset_y,btn_width,btn_height,btn_font_size,btn_font_clr,btn_bg_color,btn_border_clr,aButtonName,note3, 0,_buff,_y)

//------------------------------------------------------------------
int OnInit()
{
//template code start2  
   if(btn_show){CreateButton();}
   if(!btn_show){ObjectDelete(0,aButtonName);}
//template code end2

   int type = DRAW_LINE; if (DrawAsDots) type = DRAW_ARROW;
   IndicatorBuffers(5);

      SetIndexBuffer(0,sarUp);  SetIndexStyle(0,type,      EMPTY,UpperSARwidth,UpperSARcolor);           SetIndexArrow(0,UpperSARfontCode);      SetIndexLabel(0,"Upper SAR");
      SetIndexBuffer(1,sarDn);  SetIndexStyle(1,type,      EMPTY,LowerSARwidth,LowerSARcolor);           SetIndexArrow(1,LowerSARfontCode);      SetIndexLabel(1,"Lower SAR");
      SetIndexBuffer(2,saraUp); SetIndexStyle(2,DRAW_ARROW,EMPTY,UpperSARstartWidth,UpperSARstartColor); SetIndexArrow(2,UpperSARstartFontCode); SetIndexLabel(2,"Upper SAR start");
      SetIndexBuffer(3,saraDn); SetIndexStyle(3,DRAW_ARROW,EMPTY,LowerSARstartWidth,LowerSARstartColor); SetIndexArrow(3,LowerSARstartFontCode); SetIndexLabel(3,"Lower SAR start");
      SetIndexBuffer(4,count); 
   
      //
      //
      //
      //
      //
      
         
         PriceSmoothing    = fmax(PriceSmoothing,1);
         indicatorFileName = WindowExpertName();
         if (TimeFrameCustom==0) TimeFrameCustom = fmax(TimeFrameCustom,_Period);
         if (TimeFrame!=tf_cus)
               TimeFrame = fmax(TimeFrame,_Period);
         else  TimeFrame = (enTimeFrames)TimeFrameCustom;
         for (int i=0; i<4; i++) SetIndexShift(i,Shift*TimeFrame/_Period);
return(INIT_SUCCEEDED);
}
void OnDeinit(const int reason) {
   //template code start3
   ObjectDelete(0,aButtonName);
   //template code end3
 }
//------------------------------------------------------------------
int start()
{
//template code start4
      if(!ObjectGetInteger(0,aButtonName,OBJPROP_STATE)){
//template code end4

   int i,counted_bars=IndicatorCounted();
      if(counted_bars < 0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit = fmin(Bars-counted_bars,Bars-1); count[0] = limit;
         if (TimeFrame!=_Period)
         {
            limit = (int)fmax(limit,fmin(Bars-1,_mtfCall(4,0)*TimeFrame/Period()));
            for(i=limit; i>=0; i--)
            {
               int y =              iBarShift(NULL,TimeFrame,Time[i]);
               int x = (i<Bars-1) ? iBarShift(NULL,TimeFrame,Time[i+1]) : y;
                  sarUp[i]  = _mtfCall(0,y);
                  sarDn[i]  = _mtfCall(1,y);
                  saraUp[i] = EMPTY_VALUE;
                  saraDn[i] = EMPTY_VALUE;
                  if (x!=y)
                  {
                     saraUp[i] = _mtfCall(2,y);
                     saraDn[i] = _mtfCall(3,y);
                  }
                  
                  //
                  //
                  //
                  //
                  //
                  
                  if (!Interpolate || (i>0 && y==iBarShift(NULL,TimeFrame,Time[i-1]))) continue;
                     #define _interpolate(buff) buff[i+k] = buff[i]+(buff[i+n]-buff[i])*k/n
                     int n,k; datetime itime = iTime(NULL,TimeFrame,y);
                        for(n = 1; (i+n)<Bars && Time[i+n] >= itime; n++) continue;	
                        for(k = 1; k<n && (i+n)<Bars && (i+k)<Bars; k++)
                        {
                          if (sarUp[i+n] != EMPTY_VALUE && sarUp[i] != EMPTY_VALUE) _interpolate(sarUp);                      
                          if (sarDn[i+n] != EMPTY_VALUE && sarDn[i] != EMPTY_VALUE) _interpolate(sarDn);                      
                        }                          
               }
      return(0);
      }

      //
      //
      //
      //
      //
    
      for(i = limit; i >= 0; i--)
      {
         double sarClose;
         double sarOpen;
         double sarPosition;
         double sarChange;
         double pHigh = iMA(NULL,0,PriceSmoothing,0,PriceSmoothingMethod,PriceHigh,i);
         double pLow  = iMA(NULL,0,PriceSmoothing,0,PriceSmoothingMethod,PriceLow ,i);
            iParabolic(fmax(pHigh,pLow),fmin(pHigh,pLow),AccStep,AccLimit,sarClose,sarOpen,sarPosition,sarChange,i);
            sarUp[i]  = EMPTY_VALUE;
            sarDn[i]  = EMPTY_VALUE;
            saraUp[i] = EMPTY_VALUE;
            saraDn[i] = EMPTY_VALUE;
            if (sarPosition==1)
                  sarUp[i] = sarClose;
            else  sarDn[i] = sarClose;
            if (sarChange!=0)
               if (sarChange==1)
                     saraUp[i] = sarClose;
               else  saraDn[i] = sarClose;
      }
manageAlerts();
//template code start5
      }   
//template code end5

return(0);
}
//------------------------------------------------------------------
double work[][7];
#define _high     0
#define _low      1
#define _ohigh    2
#define _olow     3
#define _open     4
#define _position 5
#define _af       6


void iParabolic(double high, double low, double step, double limit, double& pClose, double& pOpen, double& pPosition, double& pChange, int i)
{
   if (ArrayRange(work,0)!=Bars) ArrayResize(work,Bars); i = Bars-i-1;
   
      pChange = 0;
         work[i][_ohigh]    = high;
         work[i][_olow]     = low;
            if (i<1)
               {
                  work[i][_high]     = high;
                  work[i][_low]      = low;
                  work[i][_open]     = high;
                  work[i][_position] = -1;
                  return;
               }
         work[i][_open]     = work[i-1][_open];
         work[i][_af]       = work[i-1][_af];
         work[i][_position] = work[i-1][_position];
         work[i][_high]     = fmax(work[i-1][_high],high);
         work[i][_low]      = fmin(work[i-1][_low] ,low );
                 
   if (work[i][_position] == 1)
      if (low<=work[i][_open])
         {
            work[i][_position] = -1;
               pChange = -1;
               pClose  = work[i][_high];
                         work[i][_high] = high;
                         work[i][_low]  = low;
                         work[i][_af]   = step;
                         work[i][_open] = pClose + work[i][_af]*(work[i][_low]-pClose);
                            if (work[i][_open]<work[i  ][_ohigh]) work[i][_open] = work[i  ][_ohigh];
                            if (work[i][_open]<work[i-1][_ohigh]) work[i][_open] = work[i-1][_ohigh];
         }
      else
         {
               pClose = work[i][_open];
                    if (work[i][_high]>work[i-1][_high] && work[i][_af]<limit) work[i][_af] = fmin(work[i][_af]+step,limit);
                        work[i][_open] = pClose + work[i][_af]*(work[i][_high]-pClose);
                            if (work[i][_open]>work[i  ][_olow]) work[i][_open] = work[i  ][_olow];
                            if (work[i][_open]>work[i-1][_olow]) work[i][_open] = work[i-1][_olow];
         }
   else
      if (high>=work[i][_open])
         {
            work[i][_position] = 1;
               pChange = 1;
               pClose  = work[i][_low];
                         work[i][_low]  = low;
                         work[i][_high] = high;
                         work[i][_af]   = step;
                         work[i][_open] = pClose + work[i][_af]*(work[i][_high]-pClose);
                            if (work[i][_open]>work[i  ][_olow]) work[i][_open] = work[i  ][_olow];
                            if (work[i][_open]>work[i-1][_olow]) work[i][_open] = work[i-1][_olow];
         }
      else
         {
               pClose = work[i][_open];
               if (work[i][_low]<work[i-1][_low] && work[i][_af]<limit) work[i][_af] = fmin(work[i][_af]+step,limit);
                   work[i][_open] = pClose + work[i][_af]*(work[i][_low]-pClose);
                            if (work[i][_open]<work[i  ][_ohigh]) work[i][_open] = work[i  ][_ohigh];
                            if (work[i][_open]<work[i-1][_ohigh]) work[i][_open] = work[i-1][_ohigh];
         }

   //
   //
   //
   //
   //
   
   pOpen     = work[i][_open];
   pPosition = work[i][_position];
}
//-------------------------------------------------------------------
void manageAlerts()
{
   if (alertsOn)
   {
      int whichBar = 1; if (alertsOnCurrent) whichBar = 0;
      if (saraUp[whichBar] != EMPTY_VALUE || saraDn[whichBar] != EMPTY_VALUE)
      {
         if (saraUp[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"up");
         if (saraDn[whichBar] !=  EMPTY_VALUE) doAlert(whichBar,"down");
      }
   }
}
//-------------------------------------------------------------------
void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," ",timeFrameToString(_Period)+" Parabolic sar trend changed to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"parabolic sar"),message);
          if (alertsNotify)  SendNotification(message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}
//+-------------------------------------------------------------------
string sTfTable[] = {"M1","M5","M15","M30","H1","H2","H3","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,120,180,240,1440,10080,43200};

string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
//+-------------------------------------------------------------------
//template start codes6
void CreateButton()
{
   ButtonCreate(NULL,aButtonName,0,btn_offset_x,btn_offset_y,btn_width,btn_height,btn_corner,btn_unpressed,"Arial",btn_font_size,btn_font_clr,btn_bg_color,btn_border_clr,false,true,false,false,0);
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
{
int type;
   if (id == CHARTEVENT_OBJECT_CLICK && sparam==aButtonName) 
   { 
      if(ObjectGetInteger (0,aButtonName,OBJPROP_STATE)){
         ObjectSetString  (0,aButtonName,OBJPROP_TEXT,btn_pressed); //off

         type = DRAW_LINE; if (DrawAsDots) type = DRAW_ARROW;
         SetIndexStyle(0,type,      EMPTY,UpperSARwidth,clrNONE);           
         SetIndexStyle(1,type,      EMPTY,LowerSARwidth,clrNONE);             
         SetIndexStyle(2,DRAW_ARROW,EMPTY,UpperSARstartWidth,clrNONE); 
         SetIndexStyle(3,DRAW_ARROW,EMPTY,LowerSARstartWidth,clrNONE);      
 
         }

      if(!ObjectGetInteger(0,aButtonName,OBJPROP_STATE)){
         ObjectSetString  (0,aButtonName,OBJPROP_TEXT,btn_unpressed); //on

         type = DRAW_LINE; if (DrawAsDots) type = DRAW_ARROW;
         SetIndexStyle(0,type,      EMPTY,UpperSARwidth,UpperSARcolor);           
         SetIndexStyle(1,type,      EMPTY,LowerSARwidth,LowerSARcolor);             
         SetIndexStyle(2,DRAW_ARROW,EMPTY,UpperSARstartWidth,UpperSARstartColor); 
         SetIndexStyle(3,DRAW_ARROW,EMPTY,LowerSARstartWidth,LowerSARstartColor);      
         
         }
   }
}
//+------------------------------------------------------------------+
bool ButtonCreate(const long              chart_ID   = 0,                                 // chart's ID
                  const string            name       = "Button",                         // button name
                  const int               sub_window = 0,                            // subwindow index
                  const int               x          = 0,                               // X coordinate
                  const int               y          = 0,                               // Y coordinate
                  const int               width      = 50,                              // button width
                  const int               height     = 18,                             // button height
                  const int               mycorner   = CORNER_LEFT_UPPER,
                  const string            text       = "Button",                                // text
                  const string            font       = "Arial",                                 // font
                  const int               font_size  = 10,                                 // font size
                  const color             clr        = clrBlack,                          // text color
                  const color             back_clr   = C'236,233,216',              // background color
                  const color             border_clr = clrNONE,                         // border color
                  const bool              state      = false,                       // pressed/released
                  const bool              back       = false,                      // in the background
                  const bool              selectable = true,                   //object can be selected
                  const bool              selection  = false,                      // highlight to move
                  const bool              hidden     = false,              // hidden in the object list
                  const long              z_order    = 0)                   // priority for mouse click
  {
   ResetLastError();
   ObjectCreate    (chart_ID,name,OBJ_BUTTON,          sub_window,0,0);
   ObjectSetInteger(chart_ID,name,OBJPROP_XDISTANCE,   x);
   ObjectSetInteger(chart_ID,name,OBJPROP_YDISTANCE,   y);
   ObjectSetInteger(chart_ID,name,OBJPROP_XSIZE,       width);
   ObjectSetInteger(chart_ID,name,OBJPROP_CORNER,      mycorner);
   ObjectSetString (chart_ID,name,OBJPROP_TEXT,        text);
   ObjectSetString (chart_ID,name,OBJPROP_FONT,        font);
   ObjectSetInteger(chart_ID,name,OBJPROP_FONTSIZE,    font_size);
   ObjectSetInteger(chart_ID,name,OBJPROP_COLOR,       clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BGCOLOR,     back_clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BORDER_COLOR,border_clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BACK,        back);
   ObjectSetInteger(chart_ID,name,OBJPROP_STATE,       state);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTABLE,  selection);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTED,    selection);
   ObjectSetInteger(chart_ID,name,OBJPROP_HIDDEN,      hidden);
   ObjectSetInteger(chart_ID,name,OBJPROP_ZORDER,      z_order);
   return(true);
  }
//+------------------------------------------------------------------+
//template end codes6
